// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : mainmenu.cpp
// Date           : February 2008
//
// Description    : This file defines the Menu class responsible for
//                  handling the Main Menu GUI.  Once instantiated, Update()
//                  must be called within the main game loop while the menu
//                  is active.  Start() is used to determine if a level
//                  has been selected for play.  Quit() is used to determine
//                  if the QUIT button or ESC key has been pressed to exit
//                  the application.
//
//                  GetLevel() and GetPlayer() are used to pass the selected
//                  level and player to CGame when a level is selected for
//                  play.
//
//                  Hide() and Unhide() are used to hide/unhide the main
//                  menu between level play, rather than deleting the
//                  menu each time.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once


#include <list>

#include "global.h"
#include "text.h"
#include "sound.h"
#include "GameState.h"



class Entity;

class Menu : public GameState 
{

  protected:

    float                 m_CurBarPos;
    float                 m_BarTargetTime;

    int                   m_BarPos;
    int                   m_BarStartPos;

    int                   m_BarXPos[3];
    unsigned int          m_BarColor[3];

    Entity*               m_pCurEnemy;
    float                 m_CurEnemyTime;
    std::string           m_CurEnemyName;

    std::list<std::pair<Dobbs::EntityTypes,std::string> >     m_ShowEnemies;


  public:

    Menu();
    ~Menu();


    virtual void          Render();
    virtual void          Update();
    virtual void          UpdateTimed( const float ElapsedTime );

    virtual void          Init();
    virtual void          Exit();


    virtual void          OnMouseWheel( int Dir );


};

